//
// Question 3 - Strict aliasing, restrict and optimisations
//

//
// Part 1
//

// Make sure to read through the stories on strict aliasing.

//
// Part 2
//

// No using a union to type pun is fine.
// Alternative you could use memcpy.
//
// Refer to: https://en.wikipedia.org/wiki/Type_punning

//
// Part 3
//

// Yes. The same memory is accessed through a uint32_t* and a int*

//
// Part 4
//

// No. Memcpy is the alternative way to type pun without violating strict aliasing.

//
// Part 5
//

// The compiler cannot optimise cpy2 to memcpy because the memory addresses can interleave,
// and memcpy is declared using restrict pointers, implying that they will not interleave.

// Memmove will not copy destructively as it copies backwards, however, in certain cases,
// the output will be different. Suppose we have the following:

char* s = "123456";
cpy2(s + 1, s, 4);

// This will result in a segmentation fault because "123456" is a const char*

// Suppose we have the following:

char s[] = "123456";
cpy2(s + 1, s, 4);

// Then the contents of s will be "111116"
