#include <stdio.h>
#include <malloc.h>
#include <stdbool.h>


//solution to q2 involving a single typed node with a sentinal of the same type.


typedef struct node{
    struct node* next;
    int val;
    bool sentinal;
} node;


node* list_init(int value){
    //initialise two nodes
    //sentinal node
    node* head = (node*) calloc(1,sizeof(node));
    head->sentinal = 1;
    //first node
    node* n = (node*) calloc(1,sizeof(node));
    n->val = value;
    head->next = n;
    head->sentinal = true;
    return head;
}


//helper function to get the end of our list
node* list_end(node* head){
	//while our next node still exists our head becomes the next node.
    while(head -> next){
        head = head->next;
    }
    //return our end node
    return head;
}

//we can add a node from any other given node to the end of our list.
node* list_add(node* head,int val){
    node* toAdd = (node*) calloc(1,sizeof(node));
    toAdd->val = val;
    node* end = list_end(head);
    //add node to the end
    end->next = toAdd;
    return toAdd;
}


//adds a node immediately after our current node.
node* add_next(node* node, int val){
    node* toAdd = (node*) calloc(1,sizeof(node));
    toAdd->val = val;
    //propagate our node value.
    toAdd->next = node->next;
    node->next = toAdd;
    return toAdd;
}

node* list_delete(node* head, node* n){
	//we can't remove the current node or our sentinal node.
    if (head == n || n->sentinal){
        return NULL;
    }
    //iterate through our list until we find either end of list or our node..
    while (head->next && (head->next != n)){
        head = head->next;
    }
    //if we find our node return the previous node.
    if (head->next == n){
    	//propagate your nodes
        head->next = n->next;
        //make sure you free your nodes on deletion
        free(n);
        return head;
    }
    return NULL;
}

//trivial.
node* list_next(node* n){
    return n->next;
}



void list_free (node* head){
	//utilize a temporary variable
    node* next;
    //iterate through the list.
    while(head){
        next = head->next;
        free(head);
        head = next;
    }
    return;
}


void print_all(node* head){
	while (head != NULL){
		printf("%d ",head->val);
		head = head->next;
	}
	printf("\n");


}

int main(){
    node* head = list_init(10);
    node* toRem = list_add(head, 100);
    list_add(head,50);
    list_delete(head,toRem);
    printf("%d\n",list_end(head)->val);
    list_free(head);
}
