#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>


//Circular doubly linked list, featuring a sentinal of node type.

typedef struct node{
	int val;
	struct node* next;
	struct node* prev;
	bool sentinal;

} node;

node* list_init(int val){
	node* head = (node*) malloc(sizeof(node));
	head->sentinal = true;
	node* n = (node*) calloc(1, sizeof(node));
	//this is the worst part of circular linked lists, propagating the previous and next values of both.
	n->prev = head;
	n->next = head;
	head->prev = n;
	head->next = n;
	n->val = val;
	return head;
}

node* node_add(node* head,int val){
	node* top = head;
	node* n = (node*) calloc(1, sizeof(node));
	n->val = val;
	while (head->next != top){
		head = head->next;
	}
	n->next = top;
	n->prev = head;
	head->next = n;
	top->prev = n;
	return n;
}

int node_del(node* head, node* n){
	node* top = head;
	//we can't/shouldn't delete our head.
	if (head == n){
		return 1;
	}
	//we iterate through the entire list until we encounter either our node or our head.
	while (head->next != top && (head->next != n)){
		head = head->next;
	}
	if (head->next == n){
		head->next = n->next;
		n->next->prev = head;
		free(n);
		return 0;
	}
	return 1;
}

void print_all(node* head){
	node* top = head;
	head = head->next;
	//note here, we can't look for null, we have to look for our original head.
	while (head != top){
		printf("%d ",head->val);
		head = head->next;
	}
	printf("\n");
}

//backwards using our prev pointers instead of our next pointers
void print_all_backwards(node* head){
	node* top = head;
	head = head->prev;
	//note here, we can't look for null, we have to look for our original head.
	while (head != top){
		printf("%d ",head->val);
		head = head->prev;
	}
	printf("\n");
}

node* list_next(node* n){
	return n->next;
}


//looks for a value in our list, searches both forwards and backwards. 
//Assuming our list is unordered this is probably a good way to look for things (otherwise use binary search).
node* val_search(node* head, int v){
	if (head->val = v) return head;
	node* above = head->next;
	node* below = head->prev;
	if (above->val = v) return above;
	
	while (above != below){
		above = above->next;
		if (below->val = v) return below;
		if (above == below) break;
		below = below->prev;
		if (above->val = v) return above;
	}
	return NULL;
}


void list_free(node* head){
	node* top = head;
	head = top->next;
	free(top);
	while(head != top){
		node* n = head->next;
		free(head);
		head = n;
	}

}


int main(){
	node* head = list_init(5);
	//nice part of circular linked lists, we will always get a non null/garbage next.
	printf("%d\n",head->next->next->next->next->next->next->next->next->next->next->next->next->next->val);
	
	
	
	for(int i = 0; i < 1024; i++){
		node_add(head,i);
	}
	node* n = head;
	//we can go a little out of bounds
	
	for(int i = 0; i < 2048; i++){
		printf("%d ",n->val);
		n = n->next;
	}
	
	for (int i = 0; i < 512; i++){
		node_del(head,head->next);
	}
	
	print_all(head);
	
	print_all_backwards(head);
	printf("%d\n",head->next->val);
	printf("%d\n",val_search(head,912)->val);
	
	list_free(head);
}
