#include <stdio.h>
#include <malloc.h>
#include <stdbool.h>

//not many comments here, see our q2 solutions...
typedef struct node{
    struct node* next;
    int val;
    bool sentinal;
} node;

node* list_init(int value){
    //initialise two nodes
    node* head = (node*) calloc(1,sizeof(node));
    head->sentinal = 1;
    node* n = (node*) calloc(1,sizeof(node));
    n->val = value;
    head->next = n;
    head->sentinal = true;
    n->next = head;
    return head;
}
node* list_end(node* head){
    node* cur = head;
    while(cur -> next != head){
        cur = cur->next;
    }
    return cur;
}
node* list_add(node* head,int val){
    node* toAdd = (node*) calloc(1,sizeof(node));
    toAdd->val = val;
    node* end = list_end(head);
    toAdd->next = end->next;
    end->next = toAdd;
    return toAdd;
}

node* list_delete(node* head, node* n){
    node* cur = head;
    if (head == n){
        return NULL;
    }
    while (cur->next != head){
        if (cur->next == n){
            cur->next = n->next;
            free(n);
            return cur;
        }
        cur = cur->next;
    }
    
    return NULL;
}
node* list_next(node* n){
    return n->next;
}

void list_free (node* head){
    node* cur = head->next;
    free(head);
    node* next = cur->next;
    while(cur != head){
        next = cur->next;
        free(cur);
        cur = next;
    }
    return;
}

int main(){
    node* head = list_init(10);
    node* toRem = list_add(head, 100);
    list_add(head,50);
    list_delete(head,toRem);
    printf("%d\n",list_end(head)->next->next->next->next->next->next->val);
    list_free(head);
}
