#include <stdio.h>
#include <malloc.h>
#include <string.h>

typedef struct dyn_array{
    int* arrayptr;
    int size;
    int truesize;
} dyn_array;



//simpler than our linked lists, our dynamic array resizes to always exist in 32 byte intervals


dyn_array* dyn_array_init(){
    dyn_array* out = malloc(sizeof(dyn_array));
    out->arrayptr = calloc(8, sizeof(int));
    out->size = 0;
    //pre-alocate 8 integers
    out->truesize = 8;
    return out;
}

void dyn_array_add(dyn_array* da, int value){
    if (da->size == da->truesize){
        da->truesize += 8;
        //resize our array in chunks of 8 integers.
        da->arrayptr = realloc(da->arrayptr,da->truesize * sizeof(int));
    }
    da->arrayptr[da->size++] = value;
}
void dyn_array_delete(dyn_array* da,int index){
	//if we try to delete something out of index or with a size of 0, then fail
    if (da->size == 0 || da->size < index){
        return;
    }
    da->size--;
    
    //shift everything to our index left.
    memmove(&da->arrayptr[index],&da->arrayptr[index] + 1, (da->size - index) * sizeof(int));

    if (da->truesize - 8 > da->size){
    	//reallocate if necessary.
        da->arrayptr = realloc(da->arrayptr,(da->truesize - 8) * sizeof(int));
        da->truesize -= 8;
    }
}

void dyn_array_free(dyn_array* arr){
    free(arr->arrayptr);
    free(arr);
}

int dyn_array_get(dyn_array* arr,int i){
    if (i >= arr->size){
        return 0;
    }
    return arr->arrayptr[i];
}

int main(){

	//when testing your data types I suggest adding a bunch of deterministically garbage values to them, and then deleting those values
	//just to catch logic errors that arn't caught by valgrind/fsanitize.

    dyn_array* arr = dyn_array_init();
    for (int i = 0; i < 128; i++){
        dyn_array_add(arr,i);
    }
    
    for (int i = 0; i < 24; i++){
        arr->arrayptr[10+i] = i*i;
    }

    printf("\nPrinting before deletion\n");
    for (int i = 0; i < 48; i++){
        printf("%d ",arr->arrayptr[i]);
    }
    
    
    for(int i = 0; i < 24; i++){
        dyn_array_delete(arr,10);
    }
    
    printf("\nPrinting after deletion\n");
    for (int i = 0; i < 48; i++){
        printf("%d ",arr->arrayptr[i]);
    }

    for (int i = 0; i < 128; i++){
        dyn_array_delete(arr,0);
    }
    printf("\n");


    dyn_array_free(arr);


}
