// name: Raad Fazle Karim
// unikey: rkar5915
// SID: 510168313

// code here
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define BOARD_SIZE 19
#define HOLE_SIZE 7
int mist_x = BOARD_SIZE / 2;
int mist_y = BOARD_SIZE / 2;
char view_string[49];

typedef enum { BLACK, WHITE } Player;
typedef enum { EMPTY, BLACK_STONE, WHITE_STONE } GridPoint;
typedef enum { FINISH, DRAW, ONGOING } Outcome;

typedef struct {
    int x;
    int y;
} Coordinate;

typedef struct {
    GridPoint grid[BOARD_SIZE][BOARD_SIZE];
    Coordinate mist_hole;
} Board;

typedef struct {
    Player current_player;
    Board board;
    Outcome outcome;
    int num_moves;
    Coordinate moves[BOARD_SIZE*BOARD_SIZE]; // max number of moves is BOARD_SIZE*BOARD_SIZE
} GameState;

void update_mist(char column, int row) {
    mist_x = ((5 * row * row) + (3 * row) + 4) % BOARD_SIZE;
    mist_y = 19 - (1 + ((4 * row * row) + (2 * row) - 4) % BOARD_SIZE);
}

void get_view_string(int mist_x, int mist_y, Board board, char view_string[48]) {
    // Iterate over the 7x7 grid around the mist hole
    for (int i = mist_x - 3; i <= mist_x + 3; i++) {
        for (int j = mist_y - 3; j <= mist_y + 3; j++) {
            int index = (i - mist_x + 3) * HOLE_SIZE + (j - mist_y + 3);
            if (i >= 0 && i < 19 && j >= 0 && j < 19) {
                // Inside the game board, check the content of the cell
                if (board.grid[j][i] == BLACK_STONE) {
                    view_string[index] = '#';  // black stone
                } else if (board.grid[j][i] == WHITE_STONE) {
                    view_string[index] = 'o';  // white stone
                } else if (board.grid[j][i] == EMPTY) {
                    view_string[index] = '.';  // empty cell
                }
            } else {
                // Outside the game board, mark as off-board
                view_string[(i - mist_x + 3) * 7 + (j - mist_y + 3)] = 'x';
            }
        }
    }
    for (int i = 0; i < 7; i++) {
        for (int j = 0; j < 7; j++) {
            printf("%c", view_string[j * 7 + i]);
        }  
    }
    printf("\n");
    
    // Null-terminate the string
    view_string[48] = '\0';
}


void print_history(GameState game_state) {
    //printf("\n");
    for (int i = 0; i < game_state.num_moves; ++i) {
        printf("%c%d",'A' + game_state.moves[i].x, 20 - (game_state.moves[i].y + 1));
    }
    printf("\n");
    //printf("%c%d\n", 'A' + mist_x, 20 - (mist_y + 1));
    //update_mist(int x, int y)
}

int is_valid_coordinate(char column, int row) {
    if (column < 'A' || column >= 'A' + BOARD_SIZE) {
        return 0;
    }
    if (row < 1 || row > BOARD_SIZE) {
        return 0;
    }
    return 1;
}

int is_coordinate_occupied(Board board, char column, int row) {
    if (!is_valid_coordinate(column, row)) {
        return 0;
    }
    if (board.grid[18 - (row - 1)][column - 'A'] != EMPTY) {
        printf("Occupied coordinate\n");
        return 1;
    }
    return 0;
}

int is_valid_placement(GameState game_state, char column, int row) {
    if (!is_valid_coordinate(column, row)) {
        printf("Invalid coordinate\n");
        return 0;
    }
    if (is_coordinate_occupied(game_state.board, column, row)) {
        return 0;
    }
    return 1;
}

void update_board(Board* board, Player player, char column, int row) {
    int r = 18 - (row - 1); // calculate the inverted row index
    int c = column - 'A'; // calculate the column index
    if (player == BLACK) {
        board->grid[r][c] = BLACK_STONE;
    } else {
        board->grid[r][c] = WHITE_STONE;
    }
    //update_mist(x, y);
}

Outcome check_outcome(Board board) {
    
    // Check rows for a win
    for (int i = 0; i < BOARD_SIZE; i++) {
        for (int j = 0; j <= BOARD_SIZE - 5; j++) {
            int black_count = 0;
            int white_count = 0;
            for (int k = 0; k < 5; k++) {
                if (board.grid[i][j+k] == BLACK_STONE) {
                    black_count++;
                } else if (board.grid[i][j+k] == WHITE_STONE) {
                    white_count++;
                }
            }
            if (black_count == 5) {
                printf("Black wins!\n");
                return FINISH;
            } else if (white_count == 5) {
                printf("White wins!\n");
                return FINISH;
            }
        }
    }

    // Check columns for a win
    for (int i = 0; i <= BOARD_SIZE - 5; i++) {
        for (int j = 0; j < BOARD_SIZE; j++) {
            int black_count = 0;
            int white_count = 0;
            for (int k = 0; k < 5; k++) {
                if (board.grid[i+k][j] == BLACK_STONE) {
                    black_count++;
                } else if (board.grid[i+k][j] == WHITE_STONE) {
                    white_count++;
                }
            }
            if (black_count == 5) {
                printf("Black wins!\n");
                return FINISH;
            } else if (white_count == 5) {
                printf("White wins!\n");
                return FINISH;
            }
        }
    }

    // Check diagonal lines for a win (top-left to bottom-right)
    for (int i = 0; i <= BOARD_SIZE - 5; i++) {
        for (int j = 0; j <= BOARD_SIZE - 5; j++) {
            int black_count = 0;
            int white_count = 0;
            for (int k = 0; k < 5; k++) {
                if (board.grid[i+k][j+k] == BLACK_STONE) {
                    black_count++;
                } else if (board.grid[i+k][j+k] == WHITE_STONE) {
                    white_count++;
                }
            }
            if (black_count == 5) {
                printf("Black wins!\n");
                return FINISH;
            } else if (white_count == 5) {
                printf("White wins!\n");
                return FINISH;
            }
        }
    }

    // Check diagonal lines for a win (top-right to bottom-left)
    for (int i = 4; i < BOARD_SIZE; i++) {
        for (int j = 0; j <= BOARD_SIZE - 5; j++) {
            int black_count = 0;
            int white_count = 0;
            for (int k = 0; k < 5; k++) {
                if (board.grid[i-k][j+k] == BLACK_STONE) {
                    black_count++;
                } else if (board.grid[i-k][j+k] == WHITE_STONE) {
                    white_count++;
                }
            }
            if (black_count == 5) {
                printf("Black wins!\n");
                return FINISH;
            } else if (white_count == 5) {
                printf("White wins!\n");
                return FINISH;
            }
        }
    }
    // Check if the board is full
    int empty_count = 0;
    for (int i = 0; i < BOARD_SIZE; ++i) {
        for (int j = 0; j < BOARD_SIZE; ++j) {
            if (board.grid[i][j] == EMPTY) {
                ++empty_count;
            }
        }
    }
    if (empty_count == 0) {
        printf("Wow, a tie!\n");
        return DRAW;
    }

    // No win or draw yet
    return ONGOING;
}

void execute_place_command(GameState* game_state, char column, int row) {
    if (!is_valid_placement(*game_state, column, row)) {
        //printf("Invalid coordinate\n");
        return;
    }
    update_board(&game_state->board, game_state->current_player, column, row);
    game_state->moves[game_state->num_moves].x = column - 'A';
    game_state->moves[game_state->num_moves].y = 18 - (row - 1);
    game_state->num_moves++;
}
void execute_view_command(GameState game_state) {
    printf("%c%d,", 'A' + mist_x, 20 - (mist_y + 1));
    
}

void execute_resign_command(GameState* game_state) {
    exit(0);
}

void execute_who_command(GameState game_state) {
    if (game_state.current_player == BLACK) {
        printf("B\n");
    } else {
        printf("W\n");
    }
}
int main(){
    GameState game_state = {
        .current_player = BLACK,
        .outcome = ONGOING,
        .num_moves = 0
    };
    char command[100000];
    while (game_state.outcome == ONGOING && fgets(command, sizeof(command), stdin)) {
        command[strcspn(command, "\n")] = 0;
        
        if (strlen(command) == 0 || strspn(command, " ") == strlen(command)) { 
            printf("Invalid!\n");
            continue;
        }

        if (strcmp(command, "view") == 0 && strlen(command) == 4) {
            execute_view_command(game_state);
            get_view_string(mist_x, mist_y, game_state.board, view_string);
            //printf("%s\n", view_string);
        } else if (strcmp(command, "resign" ) == 0 && strlen(command) == 6) {
            if (game_state.current_player == BLACK) {
                printf("White wins!\n");
                print_history(game_state);
                printf("Thank you for playing!\n");
            } else {
                printf("Black wins!\n");
                print_history(game_state);
                printf("Thank you for playing!\n");
            }
            execute_resign_command(&game_state);
        } else if (strcmp(command, "who") == 0 && strlen(command) == 3) {
            execute_who_command(game_state);
        } else if (strcmp(command, "history") == 0 && strlen(command) == 7) {
            print_history(game_state);
        } else if (strcmp(command, "term") == 0 && strlen(command) == 4) {
            exit(1);
        } else {
            int index = 5;
            char token[5000];
            char coordinate[5000];
            strncpy(token, command, index);
            token[index] = '\0';
            strcpy(coordinate, command+index);
            memmove(&coordinate[0], &coordinate[0 + 1], strlen(coordinate) - 0);
            //printf("%d\n", strlen(coordinate));
            if (strlen(coordinate) == 0) {
                printf("Invalid!\n");
            }
            else {

                if (strcmp(token, "place") == 0 && strlen(token) == 5 && command[index] == ' ') {
                    //char* coordinate = strtok(NULL, "");
                    if (strlen(coordinate) >= 2 && strlen(coordinate) < 4) {
                        //printf("%d", strlen(token));
                        if (strlen(coordinate) == 2 && (isspace(coordinate[0]) || isspace(coordinate[1]))) {
                            printf("Invalid!\n");
                        }
                        else if (strlen(coordinate) == 3 && (isspace(coordinate[0]) || isspace(coordinate[1]) || isspace(coordinate[2]))) {
                            printf("Invalid!\n");
                            
                        } else if (strlen(coordinate) == 3 && (coordinate[1] =='0')) {
                            printf("Invalid coordinate\n");
                        } else {
                            char column = coordinate[0];
                            int row = atoi(&coordinate[1]);
                            if (is_valid_placement(game_state, column, row)) {
                                execute_place_command(&game_state, column, row);
                                update_mist(column, row);
                                if(game_state.current_player == BLACK) {
                                    game_state.current_player = WHITE;
                                } else {
                                    game_state.current_player = BLACK;
                                }
                            }
                        }
                    }
                    else if (strlen(coordinate) < 2 || strlen(coordinate) >= 4) {
                        int count = 0;
                    for (int i = 0; i < strlen(command); i++) {
                        if (command[i] == ' ') {
                            count++;
                        }
                        
                    }
                    //printf("%d\n", count);
                    if (count == 1) {
                        printf("Invalid coordinate\n");
                    } else {
                        printf("Invalid!\n");
                    }
                    // printf("Invalid!\n");
                    // }
                    }


                } else {
                    printf("Invalid!\n");
                }
            }
        }
        
        game_state.outcome = check_outcome(game_state.board);
        if (game_state.outcome == FINISH) {
            print_history(game_state);
            printf("Thank you for playing!\n");
        } else if (game_state.outcome == DRAW) {
            print_history(game_state);
            printf("Thank you for playing!\n");
        }
    }
    return 0;
}
